#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int Uporedi(const void *a, const void *b) {
    long long val_a = *(const long long *)a;
    long long val_b = *(const long long *)b;
    if (val_a < val_b) return -1;
    if (val_a > val_b) return 1;
    return 0;
}

long long prebroj_pozdrave(long long *niz, int N) {
    if (N <= 1) return 0;

    qsort(niz, N, sizeof(long long), Uporedi);

    long long ukupan_broj_pozdrava = 0;
    long long k;
    
    for (int i = 0; i < N; i++) {
        k = 1;
        
        while (i + 1 < N && niz[i] == niz[i+1]) {
            k++;
            i++;
        }
        
        if (k >= 2) {
            ukupan_broj_pozdrava += k * (k - 1);
        }
    }

    return ukupan_broj_pozdrava;
}

void resi_zadatak() {
    int N;
    if (scanf("%d", &N) != 1) return;

    long long *u_koordinate = (long long *)malloc(N * sizeof(long long));
    long long *v_koordinate = (long long *)malloc(N * sizeof(long long));

    if (u_koordinate == NULL || v_koordinate == NULL) {
        if (u_koordinate) free(u_koordinate);
        if (v_koordinate) free(v_koordinate);
        return;
    }

    for (int i = 0; i < N; i++) {
        long long x, y;
        if (scanf("%lld %lld", &x, &y) != 2) {
            free(u_koordinate);
            free(v_koordinate);
            return;
        }

        u_koordinate[i] = x + y;
        v_koordinate[i] = x - y;
    }

    long long ukupan_broj_pozdrava = 0;

    ukupan_broj_pozdrava += prebroj_pozdrave(u_koordinate, N);

    ukupan_broj_pozdrava += prebroj_pozdrave(v_koordinate, N);

    printf("%lld\n", ukupan_broj_pozdrava);

    free(u_koordinate);
    free(v_koordinate);
}

int main() {
    resi_zadatak();
    return 0;
}